	function [hvect, H] = MULTI_STAGE_MULTIRATE(wcT, wsT, dc, ds, Nstages)
	
	%	Computes the filters in a multi-stage multirate FIR filter
	%	according to Section 15.6 using decimation and interpolation filters.
	
	%	Output:
	%	hverct is a verctor hvect(1:Nstages+1,:) of the impulse responses in 
	%	the filter stages, 1 to Nstages, and the hvect(Nstages+1,:) is 
	%	the kernel filter.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Hakan Johansson 2010-05-22
	% 	Modified by: 	LW 2010-11-16
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	lars.wanhammar@liu.se
	
	% Determine structural cases 1, 2, 3 and band edges
	cases = 0;	edges = 0; Delta = (wsT-wcT)/2; Nstage1 = Nstages+1;
	for k = 1:Nstages
		if wsT <= 0.45*pi, cases(k) = 1;
			edges(1,k) = wcT+4*Delta/3;		edges(2,k) = pi-(wcT+4*Delta/3);
			wcT = 2*wcT; 			wsT = 2*wsT;
		elseif wcT >= 0.55*pi, cases(k) = 2;
			edges(1,k) = wsT;		edges(2,k) = pi-wcT;
			wctemp = wcT;
			wcT = 2*(pi-wsT);		wsT = 2*(pi-wctemp);
		else, cases(k) = 3;
			edges(1,k) = wcT/2;		edges(2,k) = 2*pi/3-wsT/2;
			wcT = 3*wcT/2; 			wsT = 3*wsT/2;
		end
	end
	edges(1,Nstage1) = wcT;	edges(2,Nstage1) = wsT;
	
	disp(['Cases    ' num2str(cases)])
	disp(['Lower band edges/pi   ' num2str(edges(1,:)/pi)])	
	disp(['Upper band edges/pi   ' num2str(edges(2,:)/pi)])
	
	% Determine sampling ratios
	r = 1;	rates = 0;
	for k = 1:Nstages
		if cases(k) == 3,
			rates(k) = r;	r = 2*r/3; 
		else 
			rates(k) = r; r = r/2; 
		end
	end
	rates(Nstage1) = r;
	% Determine ripples
	ripples = 0;	dcNumb = 0;	dsNumb = 0;
	for k = 1:Nstages
		s = 0;
		for m = 1:k, if cases(m) == 2, s = s+1; end; end
		if mod(s,2) == 0
			dcNumb = dcNumb+1; if k == Nstages, casHt = 2; end
		else
			dsNumb = dsNumb+1; if k == Nstages, casHt = 1; end
		end
	end
	d1 = dc/(2*dcNumb+1);
	d2 = ds/(2*dsNumb+1);
	
	if casHt == 1, dcHt = d1; dsHt = d2; else dcHt = d2; dsHt = d1; end
	dsHt = min(dsHt,ds);	
	orders = 0;	% Determine orders
	for k = 1:Nstages
		if cases(k) == 1 
			orders(k) =  L_PHASE_LP_HB_FIR_ORDER(edges(2,k), min([d1,d2,ds]));
		elseif cases(k) == 2
			orders(k) = L_PHASE_LP_HB_FIR_ORDER([pi-edges(2,k) edges(2,k)], min([d1,d2, ds]));
		else
			[n, Be, D, W] = HERRMANN_LP_FIR_ORDER([edges(1,k) edges(2,k)], [min(d1,d2), ds]);
			orders(k) = 2*ceil(n/2); % Make it an even order filter
		end
	end
	[n, Be, D, W] = HERRMANN_LP_FIR_ORDER([edges(1,Nstage1) edges(2,Nstage1)], [dcHt dsHt]);
	orders(Nstage1) = 2*floor((n+1)/2);	
	hvect = zeros(Nstage1,max(orders)+1);
	disp(['Filter orders    ' num2str(orders)])
	disp(['Sampling ratios    ' num2str(rates)])	
	% Determine power of z
	for k = 1:Nstages
		if cases(k) == 3, r(k) = 3/2;	else r(k) = 2; end
	end
	delZ = 0;	delZ(Nstage1) = orders(Nstage1)/2;
	for k = Nstages:-1:1
		if cases(k) == 3
			delZ(k) = r(k)*delZ(k+1)+orders(k)/2;
		else
			delZ(k) = r(k)*delZ(k+1)+orders(k);
		end
	end

	for k = 1:Nstages
		if cases(k) == 2
			disp(['D', num2str(k) ,' = ', num2str(delZ(k))])
		end
	end
	% Group delay
	disp(['group delay = ', num2str(delZ(1)), ' T'])
	% Compute the average number of multiplications per sample
	fmax = 1;	mult = 0;	delays = 0;
	for k = 1:Nstages
		if cases(k) == 1
			mult = mult+rates(k)*(orders(k)+2)/4;
			fmax = 2*fmax;
		elseif cases(k) == 2
			mult = mult+rates(k)*(orders(k)+2)/4;
			fmax = 2*fmax;
			delays = delays+rates(k)*delZ(k);
		else
			mult = mult+rates(k)*(orders(k)+2)/3;	
			fmax = 3*fmax/2;
		end
	end
	% Average number of multiplications per sample
	format short
	mult = mult+rates(Nstages+1)*(orders(Nstages+1)+2)/2
	format long
	% Filter design
	powZ = 1./rates;
	for k = 1:Nstages
		if cases(k) == 3
			powZ(k) = powZ(k)/2;
		end
	end
	points = 16;	e = exp(1);
	[hK, Err] = REMEZ_FIR(orders(Nstages+1),[0 edges(1,Nstages+1) edges(2,Nstages+1) pi],[1 1 0 0],[dcHt dsHt], 'm');
	hvect(Nstage1,1:orders(Nstage1)+1) = hK;	% Kernel filter
	points = 2;		wT = linspace(0,720,points*720+1);
	Htot = freqz(hK,1,wT*pi/180);
	for k = Nstages:-1:1
		if cases(k) == 1	
			[hd, Err] = REMEZ_FIR(orders(k), [0 pi-edges(2,k) edges(2,k) pi],[1 1 0 0],[dcHt dsHt], 'm');
			hvect(k,1:orders(k)+1) = hd;
			points = 2*points;	wT = linspace(0,720,points*720+1);
			Hd = freqz(hd,1,wT*pi/180);
			Htot = [Htot Htot(2:length(Htot))];	Htot = Htot.*Hd.*Hd;	
		elseif cases(k) == 2	
			[hd, Err] = REMEZ_FIR(orders(k), [0 edges(2,k) pi-edges(2,k) pi],[0 0 1 1],[dcHt dsHt], 'm');
			hvect(k,1:orders(k)+1) = hd;
			points = 2*points;	wT = linspace(0,720,points*720+1);	
			Hd = freqz(hd,1,wT*pi/180);	
			Hap = e.^(-j*wT*pi*delZ(k)/180);	
			Htot = [Htot Htot(2:length(Htot))];	Htot = Hap-Htot.*Hd.*Hd;
		else	% Case 3
			Htemp = Htot;	
			Htot = [Htot(points*180+1:points*360) Htot Htot(2:points*180+1)];	
			Htot2 = [Htemp Htemp(2:points*360+1)];			
			[hd, Err] = REMEZ_FIR(orders(k), [0 edges(1,k) edges(2,k) pi],[1 1 0 0],[dcHt dsHt], 'm');
			hvect(k,1:orders(k)+1) = hd;
			points = 3*points/2;	wT = linspace(-180,180,points*720+1);	
			wT2 = linspace(0,360,points*720+1);	
			Hd = freqz(hd,1,wT*pi/180);	
			Hd2 = freqz(hd,1,wT2*pi/180);	
			Htot = Htot.*Hd.*Hd+Htot2.*Hd2.*Hd2;	
		end	
	end	
 	H = Htot(1:points*180+1);	
